/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import tschipp.carryon.common.config.Configs;

public class ListHandler {
    public static List<String> FORBIDDEN_TILES = new ArrayList<String>();
    public static List<String> FORBIDDEN_ENTITIES = new ArrayList<String>();
    public static List<String> ALLOWED_ENTITIES = new ArrayList<String>();
    public static List<String> ALLOWED_TILES = new ArrayList<String>();
    public static List<String> FORBIDDEN_STACKING = new ArrayList<String>();
    public static List<String> ALLOWED_STACKING = new ArrayList<String>();
    public static List<TagKey<Block>> FORBIDDEN_TILES_TAGS = new ArrayList<TagKey<Block>>();
    public static List<TagKey<EntityType<?>>> FORBIDDEN_ENTITIES_TAGS = new ArrayList();
    public static List<TagKey<EntityType<?>>> ALLOWED_ENTITIES_TAGS = new ArrayList();
    public static List<TagKey<Block>> ALLOWED_TILES_TAGS = new ArrayList<TagKey<Block>>();
    public static List<TagKey<EntityType<?>>> FORBIDDEN_STACKING_TAGS = new ArrayList();
    public static List<TagKey<EntityType<?>>> ALLOWED_STACKING_TAGS = new ArrayList();

    public static boolean isForbidden(Block block) {
        String name = block.getRegistryName().toString();
        if (FORBIDDEN_TILES.contains(name)) {
            return true;
        }
        boolean contains = false;
        for (String string : FORBIDDEN_TILES) {
            String[] filter;
            if (!string.contains("*") || !ListHandler.containsAll(name, filter = string.replace("*", ",").split(","))) continue;
            contains = true;
        }
        for (TagKey tagKey : FORBIDDEN_TILES_TAGS) {
            if (!block.m_49966_().m_204336_(tagKey)) continue;
            return true;
        }
        return contains;
    }

    public static boolean isForbidden(Entity entity) {
        String name = entity.m_6095_().getRegistryName().toString();
        boolean contains = FORBIDDEN_ENTITIES.contains(name);
        for (TagKey<EntityType<?>> tag : FORBIDDEN_ENTITIES_TAGS) {
            if (!entity.m_6095_().m_204039_(tag)) continue;
            return true;
        }
        return contains;
    }

    public static boolean isAllowed(Entity entity) {
        String name = entity.m_6095_().getRegistryName().toString();
        boolean contains = ALLOWED_ENTITIES.contains(name);
        for (TagKey<EntityType<?>> tag : ALLOWED_ENTITIES_TAGS) {
            if (!entity.m_6095_().m_204039_(tag)) continue;
            return true;
        }
        return contains;
    }

    public static boolean isStackingForbidden(Entity entity) {
        String name = entity.m_6095_().getRegistryName().toString();
        boolean contains = FORBIDDEN_STACKING.contains(name);
        for (TagKey<EntityType<?>> tag : FORBIDDEN_STACKING_TAGS) {
            if (!entity.m_6095_().m_204039_(tag)) continue;
            return true;
        }
        return contains;
    }

    public static boolean isStackingAllowed(Entity entity) {
        String name = entity.m_6095_().getRegistryName().toString();
        boolean contains = ALLOWED_STACKING.contains(name);
        for (TagKey<EntityType<?>> tag : ALLOWED_STACKING_TAGS) {
            if (!entity.m_6095_().m_204039_(tag)) continue;
            return true;
        }
        return contains;
    }

    public static boolean isAllowed(Block block) {
        String name = block.getRegistryName().toString();
        if (ALLOWED_TILES.contains(name)) {
            return true;
        }
        boolean contains = false;
        for (String string : ALLOWED_TILES) {
            String[] filter;
            if (!string.contains("*") || !ListHandler.containsAll(name, filter = string.replace("*", ",").split(","))) continue;
            contains = true;
        }
        for (TagKey tagKey : ALLOWED_TILES_TAGS) {
            if (!block.m_49966_().m_204336_(tagKey)) continue;
            return true;
        }
        return contains;
    }

    public static void initConfigLists() {
        FORBIDDEN_ENTITIES.clear();
        FORBIDDEN_ENTITIES_TAGS.clear();
        FORBIDDEN_STACKING.clear();
        FORBIDDEN_STACKING_TAGS.clear();
        FORBIDDEN_TILES.clear();
        FORBIDDEN_TILES_TAGS.clear();
        ALLOWED_ENTITIES.clear();
        ALLOWED_ENTITIES_TAGS.clear();
        ALLOWED_STACKING.clear();
        ALLOWED_STACKING_TAGS.clear();
        ALLOWED_TILES.clear();
        ALLOWED_TILES_TAGS.clear();
        ArrayList<String> forbidden = new ArrayList<String>((Collection)Configs.Blacklist.forbiddenTiles.get());
        forbidden.add("#carryon:block_blacklist");
        FORBIDDEN_TILES = new ArrayList<String>();
        for (int i = 0; i < forbidden.size(); ++i) {
            if (((String)forbidden.get(i)).startsWith("#")) continue;
            FORBIDDEN_TILES.add((String)forbidden.get(i));
        }
        ArrayList<String> forbiddenEntity = new ArrayList<String>((Collection)Configs.Blacklist.forbiddenEntities.get());
        forbiddenEntity.add("#carryon:entity_blacklist");
        FORBIDDEN_ENTITIES = new ArrayList<String>();
        for (int i = 0; i < forbiddenEntity.size(); ++i) {
            if (((String)forbiddenEntity.get(i)).startsWith("#")) continue;
            if (((String)forbiddenEntity.get(i)).contains("*")) {
                ResourceLocation[] keys;
                String[] filter = ((String)forbiddenEntity.get(i)).replace("*", ",").split(",");
                for (ResourceLocation key : keys = ForgeRegistries.ENTITIES.getKeys().toArray(new ResourceLocation[0])) {
                    if (!ListHandler.containsAll(key.toString(), filter)) continue;
                    FORBIDDEN_ENTITIES.add(key.toString());
                }
            }
            FORBIDDEN_ENTITIES.add((String)forbiddenEntity.get(i));
        }
        ArrayList<String> allowedEntities = new ArrayList<String>((Collection)Configs.WhiteList.allowedEntities.get());
        allowedEntities.add("#carryon:entity_whitelist");
        ALLOWED_ENTITIES = new ArrayList<String>();
        for (int i = 0; i < allowedEntities.size(); ++i) {
            if (((String)allowedEntities.get(i)).startsWith("#")) continue;
            if (((String)allowedEntities.get(i)).contains("*")) {
                ResourceLocation[] keys;
                String[] filter = ((String)allowedEntities.get(i)).replace("*", ",").split(",");
                for (ResourceLocation key : keys = ForgeRegistries.ENTITIES.getKeys().toArray(new ResourceLocation[0])) {
                    if (!ListHandler.containsAll(key.toString(), filter)) continue;
                    ALLOWED_ENTITIES.add(key.toString());
                }
            }
            ALLOWED_ENTITIES.add((String)allowedEntities.get(i));
        }
        ArrayList<String> allowedBlocks = new ArrayList<String>((Collection)Configs.WhiteList.allowedBlocks.get());
        allowedBlocks.add("#carryon:block_whitelist");
        ALLOWED_TILES = new ArrayList<String>();
        for (int i = 0; i < allowedBlocks.size(); ++i) {
            if (((String)allowedBlocks.get(i)).startsWith("#")) continue;
            ALLOWED_TILES.add((String)allowedBlocks.get(i));
        }
        ArrayList<String> forbiddenStacking = new ArrayList<String>((Collection)Configs.Blacklist.forbiddenStacking.get());
        forbiddenStacking.add("#carryon:stacking_blacklist");
        FORBIDDEN_STACKING = new ArrayList<String>();
        for (int i = 0; i < forbiddenStacking.size(); ++i) {
            if (((String)forbiddenStacking.get(i)).startsWith("#")) continue;
            if (((String)forbiddenStacking.get(i)).contains("*")) {
                ResourceLocation[] keys;
                String[] filter = ((String)forbiddenStacking.get(i)).replace("*", ",").split(",");
                for (ResourceLocation key : keys = ForgeRegistries.ENTITIES.getKeys().toArray(new ResourceLocation[0])) {
                    if (!ListHandler.containsAll(key.toString(), filter)) continue;
                    FORBIDDEN_STACKING.add(key.toString());
                }
            }
            FORBIDDEN_STACKING.add((String)forbiddenStacking.get(i));
        }
        ArrayList<String> allowedStacking = new ArrayList<String>((Collection)Configs.WhiteList.allowedStacking.get());
        allowedStacking.add("#carryon:stacking_whitelist");
        ALLOWED_STACKING = new ArrayList<String>();
        for (int i = 0; i < allowedStacking.size(); ++i) {
            if (((String)allowedStacking.get(i)).startsWith("#")) continue;
            if (((String)allowedStacking.get(i)).contains("*")) {
                ResourceLocation[] keys;
                String[] filter = ((String)allowedStacking.get(i)).replace("*", ",").split(",");
                for (ResourceLocation key : keys = ForgeRegistries.ENTITIES.getKeys().toArray(new ResourceLocation[0])) {
                    if (!ListHandler.containsAll(key.toString(), filter)) continue;
                    ALLOWED_STACKING.add(key.toString());
                }
            }
            ALLOWED_STACKING.add((String)allowedStacking.get(i));
        }
        Map<ResourceLocation, TagKey> blocktags = Registry.f_122824_.m_203613_().collect(Collectors.toMap(t -> t.f_203868_(), t -> t));
        Map<ResourceLocation, TagKey> entitytags = Registry.f_122826_.m_203613_().collect(Collectors.toMap(t -> t.f_203868_(), t -> t));
        for (String s : forbidden) {
            String sub;
            TagKey tag;
            if (!s.startsWith("#") || (tag = blocktags.get(new ResourceLocation(sub = s.substring(1)))) == null) continue;
            FORBIDDEN_TILES_TAGS.add((TagKey<Block>)tag);
        }
        for (String s : allowedBlocks) {
            TagKey tag;
            if (!s.startsWith("#") || (tag = blocktags.get(new ResourceLocation(s.substring(1)))) == null) continue;
            ALLOWED_TILES_TAGS.add((TagKey<Block>)tag);
        }
        for (String s : forbiddenEntity) {
            TagKey tag;
            if (!s.startsWith("#") || (tag = entitytags.get(new ResourceLocation(s.substring(1)))) == null) continue;
            FORBIDDEN_ENTITIES_TAGS.add(tag);
        }
        for (String s : allowedEntities) {
            TagKey tag;
            if (!s.startsWith("#") || (tag = entitytags.get(new ResourceLocation(s.substring(1)))) == null) continue;
            ALLOWED_ENTITIES_TAGS.add(tag);
        }
        for (String s : forbiddenStacking) {
            TagKey tag;
            if (!s.startsWith("#") || (tag = entitytags.get(new ResourceLocation(s.substring(1)))) == null) continue;
            FORBIDDEN_STACKING_TAGS.add(tag);
        }
        for (String s : allowedStacking) {
            TagKey tag;
            if (!s.startsWith("#") || (tag = entitytags.get(new ResourceLocation(s.substring(1)))) == null) continue;
            ALLOWED_STACKING_TAGS.add(tag);
        }
    }

    public static boolean containsAll(String str, String ... strings) {
        boolean containsAll = true;
        for (String s : strings) {
            if (str.contains(s)) continue;
            containsAll = false;
        }
        return containsAll;
    }
}

